<?php
// إعدادات قاعدة البيانات
$host = 'localhost';
$db   = 'invoice_db';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (PDOException $e) {
    echo "فشل الاتصال بقاعدة البيانات: " . $e->getMessage();
    exit;
}

// إنشاء جدول الفواتير (نفذ هذا مرة واحدة فقط)
/*
$pdo->exec("
    CREATE TABLE IF NOT EXISTS invoices (
        id INT AUTO_INCREMENT PRIMARY KEY,
        client_name VARCHAR(255) NOT NULL,
        service_name VARCHAR(255) NOT NULL,
        amount DECIMAL(10,2) NOT NULL,
        currency ENUM('EGP', 'USD') NOT NULL,
        due_date DATE NOT NULL
    )
");
*/

// إضافة فاتورة جديدة (نفذ مرة واحدة فقط ثم علّق الكود)
/*
$pdo->prepare("INSERT INTO invoices (client_name, service_name, amount, currency, due_date) 
    VALUES (?, ?, ?, ?, ?)")
    ->execute(['أحمد علي', 'تصميم موقع', 1500, 'EGP', '2025-07-01']);
*/

// جلب الفواتير
$stmt = $pdo->query("SELECT * FROM invoices ORDER BY due_date ASC");
$invoices = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>قائمة الفواتير</title>
    <style>
        body { font-family: Tahoma, sans-serif; background: #f4f4f4; margin: 0; padding: 20px; }
        table { width: 100%; border-collapse: collapse; background: white; box-shadow: 0 0 5px #ccc; }
        th, td { padding: 10px; border: 1px solid #ddd; text-align: center; }
        th { background: #009688; color: white; }
    </style>
</head>
<body>
    <h2>📄 الفواتير الحالية</h2>
    <table>
        <tr>
            <th>#</th>
            <th>العميل</th>
            <th>الخدمة</th>
            <th>المبلغ</th>
            <th>العملة</th>
            <th>تاريخ الاستحقاق</th>
        </tr>
        <?php foreach ($invoices as $invoice): ?>
        <tr>
            <td><?= $invoice['id'] ?></td>
            <td><?= htmlspecialchars($invoice['client_name']) ?></td>
            <td><?= htmlspecialchars($invoice['service_name']) ?></td>
            <td><?= $invoice['amount'] ?></td>
            <td><?= $invoice['currency'] ?></td>
            <td><?= $invoice['due_date'] ?></td>
        </tr>
        <?php endforeach; ?>
    </table>
</body>
</html>
