CREATE DATABASE IF NOT EXISTS invoice_db;
USE invoice_db;

CREATE TABLE IF NOT EXISTS invoices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    client_name VARCHAR(100),
    client_email VARCHAR(100),
    service_description TEXT,
    currency ENUM('EGP', 'USD') DEFAULT 'EGP',
    amount DECIMAL(10,2),
    issue_date DATE,
    due_date DATE,
    status ENUM('Paid', 'Unpaid') DEFAULT 'Unpaid',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);